//	Draw4DApp.swift
//
//	© 2025 by Jeff Weeks
//	See TermsOfUse.txt

import SwiftUI


@main
struct Draw4DApp: App {
	
	init() {

#if targetEnvironment(simulator)
		//	When creating screenshots in the simulator,
		//	we'll need to know where to put source files
		//	for the desired drawings.
		PrintDocumentDirectoryPathToConsole()
#endif
	}
	
	var body: some Scene {
	
#if os(iOS)
		DocumentGroup(newDocument: { Draw4DDocument() }) { file in

			Draw4DContentView(
				document: file.document,
				fileURL: file.fileURL
			)
		}
#endif
#if os(macOS)

		let theTestWindowSize = CGSize(width: 512.0, height: 512.0)
		let theTestContentSize = NSWindow.contentRect(
									forFrameRect: NSRect(
													origin: .zero,
													size: theTestWindowSize),
									styleMask: .titled)
		let theTitleBarHeight = theTestWindowSize.height - theTestContentSize.height

		DocumentGroup(newDocument: { Draw4DDocument() }) { file in

			Draw4DContentView(
				document: file.document,
				fileURL: file.fileURL
			)
		}
		//	Request a window size that gives a square content area
		//	after allowing space for the title bar.
		//	(Exception: Screenshots must be rectangular.)
		.defaultSize(
			width:  gMakeScreenshots ? 1280.0 : 680.0,
			height: gMakeScreenshots ?  800.0 : 680.0 + theTitleBarHeight)

#endif
	}
}
